/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlabfishModel<E extends SlabfishEntity>
extends AgeableModel<E> {
    public ModelRenderer body;
    public ModelRenderer rightLeg;
    public ModelRenderer leftLeg;
    public ModelRenderer rightArm;
    public ModelRenderer leftArm;
    public ModelRenderer fin;
    public ModelRenderer backpack;
    public TextureAtlasSprite sprite;
    private float partialTicks;

    public SlabfishModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.leftArm = new ModelRenderer((Model)this, 16, 14);
        this.leftArm.field_78809_i = true;
        this.leftArm.func_78793_a(5.0f, -4.0f, 0.0f);
        this.leftArm.func_228301_a_(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.leftArm, 0.0f, 0.0f, -0.43633232f);
        this.body = new ModelRenderer((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 19.0f, 0.0f);
        this.body.func_228301_a_(-5.0f, -10.0f, -2.0f, 10.0f, 10.0f, 4.0f, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 16, 14);
        this.rightArm.func_78793_a(-5.0f, -4.0f, 0.0f);
        this.rightArm.func_228301_a_(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.rightArm, 0.0f, 0.0f, 0.43633232f);
        this.fin = new ModelRenderer((Model)this, 24, 12);
        this.fin.func_78793_a(0.0f, -4.0f, 2.0f);
        this.fin.func_228301_a_(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.fin, -0.21816616f, 0.0f, 0.0f);
        this.backpack = new ModelRenderer((Model)this, 8, 20);
        this.backpack.func_78793_a(0.0f, 0.0f, 0.0f);
        this.backpack.func_228301_a_(-4.0f, -8.0f, 2.0f, 8.0f, 8.0f, 4.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 0, 14);
        this.leftLeg.field_78809_i = true;
        this.leftLeg.func_78793_a(2.5f, 19.0f, 1.0f);
        this.leftLeg.func_228301_a_(-1.5f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 0, 14);
        this.rightLeg.func_78793_a(-2.5f, 19.0f, 1.0f);
        this.rightLeg.func_228301_a_(-1.5f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, 0.0f);
        this.body.func_78792_a(this.leftArm);
        this.body.func_78792_a(this.rightArm);
        this.body.func_78792_a(this.fin);
        this.body.func_78792_a(this.backpack);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.partialTicks = partialTicks;
    }

    public void setupAnim(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean bl = this.fin.field_78806_j = !((SlabfishEntity)((Object)entityIn)).hasBackpack();
        if (!entityIn.func_70090_H()) {
            if (((SlabfishEntity)((Object)entityIn)).isPartying()) {
                float f = MathHelper.func_76134_b((float)((float)((SlabfishEntity)((Object)entityIn)).field_70173_aa + this.partialTicks));
                float f1 = MathHelper.func_76126_a((float)((float)((SlabfishEntity)((Object)entityIn)).field_70173_aa + this.partialTicks));
                this.body.field_78798_e = f;
                this.body.field_78797_d = 19.75f - f1;
            }
            this.rightArm.field_78808_h = ageInTicks;
            this.leftArm.field_78808_h = -ageInTicks;
            this.rightLeg.field_78795_f = entityIn.func_233684_eK_() || entityIn.func_184187_bx() != null ? -1.57f : MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.5f * limbSwingAmount;
            this.leftLeg.field_78795_f = entityIn.func_233684_eK_() || entityIn.func_184187_bx() != null ? -1.57f : MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.5f * limbSwingAmount;
        } else {
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
            this.rightArm.field_78808_h = ageInTicks;
            this.leftArm.field_78808_h = -ageInTicks;
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.func_225598_a_(matrixStack, this.sprite.func_229230_a_(buffer), packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg);
    }
}

